<?php

namespace App\Controllers;

use App\Models\ActivityModel;

class ActivitiesController extends BaseController
{
    protected $activityModel;

    public function __construct()
    {
        $this->activityModel = new ActivityModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search') ?? '';
        $filter = [
            'tanggal_dari' => $this->request->getGet('tanggal_dari') ?? '',
            'tanggal_sampai' => $this->request->getGet('tanggal_sampai') ?? ''
        ];
        $sort = $this->request->getGet('sort') ?? 'tanggal';
        $order = $this->request->getGet('order') ?? 'DESC';
        $page = (int)($this->request->getGet('page') ?? 1);

        $builder = $this->activityModel->searchAndFilter($search, $filter, $sort, $order);
        $total = $builder->countAllResults(false);
        
        $perPage = 10;
        $activities = $builder->get($perPage, ($page - 1) * $perPage)->getResultArray();

        $pager = \Config\Services::pager();
        $pager->store('activities', $page, $perPage, $total);
        
        // Calculate last page manually to ensure it works
        $lastPage = (int) ceil($total / $perPage);

        $data = [
            'title' => 'Aktivitas Harian - Portfolio',
            'activities' => $activities,
            'pager' => $pager,
            'lastPage' => $lastPage,
            'currentPage' => $page,
            'total' => $total,
            'search' => $search,
            'filter' => $filter,
            'sort' => $sort,
            'order' => $order
        ];

        return view('activities/index', $data);
    }
}

